/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.pi.PIHscFoDCIMClient;
import com.ibm.hsc.client.PIFoDCodeInfoDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCFoDClient;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PIVetList {
    private static final int NUM_VALID_PARMS = 5;
    private String m_function;
    private String m_managedSystem;
    private String m_listType;
    private String m_format;
    private boolean m_header;
    private HashMap m_validParms = new HashMap(11, 0.5f);
    private PIHSCCECClient m_CECClient = null;
    private PIHSCFoDClient m_fodClient = null;
    private String m_delimiter = ",";
    private PrintStream m_out;
    private boolean m_writeStatus;
    private static final String LIST_CODE = "code";
    private static final String LIST_HISTORY = "hist";
    private static final String ADVANCED_VIRTUALIZATION_FUNCTION = "advirt";

    private PIVetList(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-f", null);
        this.m_validParms.put("-t", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
    }

    private void doCodeInfoList() throws PIHscClientException {
        String[] stringArray;
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, PIFoDCodeInfoDataBean.ALL_KEYS, PIFoDCodeInfoDataBean.ALL_KEYS.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(PIFoDCodeInfoDataBean.ALL_KEYS, this.m_format, this.m_delimiter);
        } else {
            stringArray = PIFoDCodeInfoDataBean.ALL_KEYS;
        }
        PIFoDCodeInfoDataBean pIFoDCodeInfoDataBean = this.m_fodClient.GetFoDOrderInfo(3);
        Vector<PIFoDCodeInfoDataBean> vector = new Vector<PIFoDCodeInfoDataBean>();
        vector.addElement(pIFoDCodeInfoDataBean);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doHistoryList() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"time_stamp", "entry"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector vector = this.m_fodClient.getFoDHistoryLog();
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        this.m_fodClient = PIHscFoDCIMClient.createInstance(this.m_CECClient);
        if (LIST_CODE.equals(this.m_listType)) {
            this.doCodeInfoList();
        } else {
            this.doHistoryList();
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (this.m_listType == null || !LIST_CODE.equals(this.m_listType) && !LIST_HISTORY.equals(this.m_listType)) {
            string = string + ", -t";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_header && this.m_format == null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
        }
        if (this.m_function != null && !ADVANCED_VIRTUALIZATION_FUNCTION.equals(this.m_function)) {
            String[] stringArray = new String[]{"-f"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_function = (String)hashMap.get("-f");
        this.m_listType = (String)hashMap.get("-t");
        this.m_format = (String)hashMap.get("-F");
        String string = (String)hashMap.get("--header");
        this.m_header = string != null;
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSVET_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIVetList pIVetList = new PIVetList(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIVetList.m_validParms);
            pIVetList.mapParameters(hashMap);
            pIVetList.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
                bl = false;
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

